#!/usr/bin/perl
#####################################################
# KeyFinder.pl                                      #
# Takes recipients on standard input, gets keyring  #
# from gpg, then sends information to standard      #
# output                                            #
#                                                   #
#                                                   #
# Usage:                                            #
# KeyFinder.pl [-t]                                 #
#                                                   #
#   -t       respect gpg trust levels               #
#                                                   #
#                                                   #
# Input must be a list of keys separated by lf's    #
#                                                   #
# Output is first a list of all keys, two lf's,     #
# then a list of the keys of the keys that were     #
# found on the keyring, then a list of keys that    #
# were not found on the keyring                     #
#                                                   #
#                                                   #
# 2002 Simon Kornblith. All Rights Reserved.       #
# Part of the EntourageGPG Project.                 #
#                                                   #
# Licensed under the GNU Public License             #
#####################################################

# These are related to recipient matching
my @notFound;
# These are miscellaneous
my $gpgResult, $trust;

$trust = shift @ARGV;
if($trust) {
	$matchChar = "[^-]";
} else {
	$matchChar = ".";
}

$gpgResult = `gpg --list-keys --with-colons`;

if($gpgResult eq "sh: gpg: command not found") {
	print STDERR $gpgResult;
	exit;
}

$_ = $gpgResult;
$, = "\n";
print m/pub:$matchChar:.*?:.*?:.*?:.*?:.*?:.*?:.*?:(.+):.*?:.*?:/g;
print "\n\n";

while(<STDIN>) {
	chomp;
	if($gpgResult =~ m/...:$matchChar:.*?:.*?:.*?:.*?:.*?:.*?:.*?:(.*<\Q$_\E>):.*?:.*?:/o) {
		print $gpgResult =~ m/...:$matchChar:.*?:.*?:.*?:.*?:.*?:.*?:.*?:(.*<\Q$_\E>):.*?:.*?:/o
	} else {
		$notFound[++$#notFound] = $_;
	}
}

print "\n\n";
if($# == 0) {
	print "\n";
} else {
	print @notFound;
}